﻿
Partial Class ShoppingControlCart
    Inherits System.Web.UI.UserControl

    Private Sub BindGrid()
        CartGrid.DataSource = Profile.Cart.items
        DataBind()
        Label1.Text = String.Format("Total :{0,19:C}", Profile.Cart.Total)
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If Profile.Cart Is Nothing Then
            '    Profile.Cart = New rayaneh.commerce.ShoppingCart()
            Return
        End If
        If Not Page.IsPostBack Then
            BindGrid()
        End If
        If Profile.Cart.Items.Count = 0 Then
            Label1.Visible = False
        End If
    End Sub

    Protected Sub CartGrid_RowEditing(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewEditEventArgs) Handles CartGrid.RowEditing
        CartGrid.EditIndex = e.NewEditIndex
        BindGrid()
    End Sub

    Protected Sub CartGrid_RowUpdating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewUpdateEventArgs) Handles CartGrid.RowUpdating
        Dim quantityTextBox As TextBox = CType(CartGrid.Rows(e.RowIndex).Cells(2).Controls(0), TextBox)
        Dim quantity As Integer = System.Convert.ToInt32(quantityTextBox.Text)
        If quantity = 0 Then
            Profile.Cart.items.RemoveAt(e.RowIndex)
        Else
            Profile.Cart.Items(e.RowIndex).Quantity = quantity
        End If
        CartGrid.EditIndex = -1
        BindGrid()
    End Sub

    Protected Sub CartGrid_RowCancelingEdit(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewCancelEditEventArgs) Handles CartGrid.RowCancelingEdit
        CartGrid.EditIndex = -1
        BindGrid()
    End Sub

    Protected Sub CartGrid_RowDeleting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewDeleteEventArgs) Handles CartGrid.RowDeleting
        Profile.Cart.items.RemoveAt(e.RowIndex)
        BindGrid()
    End Sub
End Class
